CombatLogger = {}
CombatLogger.SavedSettings = {}

-- saved values
playSound = nil
MAX_FILE_LINES = nil

-- runtime values
recordingStarted = false
recordingPaused = false
playerName = "unknownPlayer"
logFileName = "cl-default"
recordedLines = 0

function CombatLogger.OnInitialize()
	
	-- register command with lib slash addon
	if LibSlash then
		LibSlash.RegisterSlashCmd("cl", function(args) CombatLogger.SlashCmd(args) end)
	end
	
	-- load settings
	CombatLogger.loadSettings()

	-- get player name
	playerName = CombatLogger.rname(wstring.sub(GameData.Player.name, 1, -3))

	-- event hook
	RegisterEventHandler(TextLogGetUpdateEventId("Combat"), "CombatLogger.OnCombatLogUpdated")
	
	Echo("<LINK data=\"0\" text=\"[CombatLogger]\" color=\"50,255,10\"> Addon initialized.")
end

-- supported slash commands
function CombatLogger.SlashCmd(args)

	-- check number of words command consists of
	local input1 = string.sub(args,0,string.find(args," "))
	if string.find(args," ") ~= nil then
		input1 = string.sub(args,0,string.find(args," ")-1)
		input2 = string.sub(args,string.find(args," ")+1,-1)
	end

	-- actons based on imput
	if input1 == "start" then CombatLogger.start()
	elseif input1 == "stop" then CombatLogger.stop()
	elseif input1 == "pause" then CombatLogger.togglePause()
	elseif input1 == "sound" then CombatLogger.toggleSound()
	elseif input1 == "showlimit" then CombatLogger.getMaxLogLines()
	elseif input1 == "setlimit" then CombatLogger.setMaxLogLines(input2)
	elseif input1 == "" or input1 == "help" then
	Echo("<LINK data=\"0\" text=\"[CombatLogger]\" color=\"50,255,10\"> Available commands:")
	Echo("<LINK data=\"0\" text=\"[CombatLogger]\" color=\"50,255,10\"> <LINK data=\"0\" text=\"/cl start\" color=\"255,255,10\"> - starts recording a new log")
	Echo("<LINK data=\"0\" text=\"[CombatLogger]\" color=\"50,255,10\"> <LINK data=\"0\" text=\"/cl stop\" color=\"255,255,10\"> - stops recording current log")
	Echo("<LINK data=\"0\" text=\"[CombatLogger]\" color=\"50,255,10\"> <LINK data=\"0\" text=\"/cl pause\" color=\"255,255,10\"> - pauses/unpauses recording current log")
	Echo("<LINK data=\"0\" text=\"[CombatLogger]\" color=\"50,255,10\"> <LINK data=\"0\" text=\"/cl sound\" color=\"255,255,10\"> - toggles sound OFF if it was ON previously and vice versa")
	Echo("<LINK data=\"0\" text=\"[CombatLogger]\" color=\"50,255,10\"> <LINK data=\"0\" text=\"/cl showlimit\" color=\"255,255,10\"> - prints how many lines addon is currently allowed to save")
	Echo("<LINK data=\"0\" text=\"[CombatLogger]\" color=\"50,255,10\"> <LINK data=\"0\" text=\"/cl setlimit n\" color=\"255,255,10\"> - sets log line limit to <LINK data=\"0\" text=\"n\" color=\"255,255,10\">")	
	end
end

function CombatLogger.OnCombatLogUpdated(updateType, filterType)
	
	if not(updateType == SystemData.TextLogUpdate.ADDED) then
		return
	end
	
	if ( recordingStarted and (not recordingPaused)) then

		-- isolate the new combat log line
		local _, filterId, text = TextLogGetEntry( "Combat", TextLogGetNumEntries("Combat") - 1 )

		-- save line to file
		TextLogAddEntry(logFileName, 0, towstring(text))
		TextLogSaveLog(logFileName)

		recordedLines = recordedLines + 1
		if (recordedLines == MAX_FILE_LINES) then
			CombatLogger.stop()
		end
	end
end

function CombatLogger.start()

	if recordingStarted then
		Echo("<LINK data=\"0\" text=\"[CombatLogger]\" color=\"255,50,50\"> Can't start; already recording")
		return
	end

	recordingStarted = true
	
	-- create a new log file
	local timestamp = CombatLogger.getTimeStamp()
	logFileName = "cl-" .. timestamp  .. "-" .. playerName
	TextLogCreate(logFileName, MAX_FILE_LINES)
	TextLogSetEnabled(logFileName, true)
	TextLogSetIncrementalSaving(logFileName, true, StringToWString("logs/"..logFileName..".log"))
	
	Echo("<LINK data=\"0\" text=\"[CombatLogger]\" color=\"50,255,10\"> Logging to " ..logFileName.. ".log")
	if playSound then
		PlaySound(GameData.Sound.QUEST_ACCEPTED)
	end
end


function CombatLogger.togglePause()
	-- pause is currenlty ON
	if recordingPaused then
		if not recordingStarted then
			Echo("<LINK data=\"0\" text=\"[CombatLogger]\" color=\"255,50,50\"> Can't unpause; addon is not recording")
			return
		end
		Echo("<LINK data=\"0\" text=\"[CombatLogger]\" color=\"255,255,10\"> Unpausing " ..logFileName.. ".log, " ..recordedLines.. " lines")
		recordingPaused = false
	-- pause is currenlty OFF
	else
		if not recordingStarted then
			Echo("<LINK data=\"0\" text=\"[CombatLogger]\" color=\"255,50,50\"> Can't pause; addon is not recording")
			return
		end
		Echo("<LINK data=\"0\" text=\"[CombatLogger]\" color=\"255,255,10\"> Pausing " ..logFileName.. ".log, " ..recordedLines.. " lines")
		recordingPaused = true
	end
end

function CombatLogger.stop()
	if not recordingStarted then
		Echo("<LINK data=\"0\" text=\"[CombatLogger]\" color=\"255,50,50\"> Can't stop; addon is not recording")
		return
	end
	Echo("<LINK data=\"0\" text=\"[CombatLogger]\" color=\"50,255,10\"> saved " ..recordedLines.. " lines to " ..logFileName.. ".log")
	TextLogDestroy(logFileName)
	logFileName = "cl-default"
	recordingStarted = false
	recordingPaused = false
	recordedLines = 0
	if playSound then
		PlaySound(GameData.Sound.QUEST_COMPLETED)
	end
end

function CombatLogger.toggleSound()
	if playSound then
		playSound = false
		Echo("<LINK data=\"0\" text=\"[CombatLogger]\" color=\"50,255,10\"> Sound is now <LINK data=\"0\" text=\"OFF\" color=\"255,50,50\">")
	else
		playSound = true
		Echo("<LINK data=\"0\" text=\"[CombatLogger]\" color=\"50,255,10\"> Sound is now <LINK data=\"0\" text=\"ON\" color=\"50,255,10\">")
	end
end

function CombatLogger.setMaxLogLines(n)
	if recordingStarted then
		Echo("<LINK data=\"0\" text=\"[CombatLogger]\" color=\"255,50,50\"> Unable to change log file size while addon is recording.")
		return
	end
	MAX_FILE_LINES = tonumber(n)
	CombatLogger.SavedSettings.MAX_FILE_LINES = MAX_FILE_LINES
	Echo("<LINK data=\"0\" text=\"[CombatLogger]\" color=\"50,255,10\"> Maximum log file size is now " ..MAX_FILE_LINES.. " lines.")
end

function CombatLogger.getMaxLogLines()
	Echo("<LINK data=\"0\" text=\"[CombatLogger]\" color=\"50,255,10\"> Maximum log file size is " ..MAX_FILE_LINES .. " lines.")
end

function CombatLogger.loadSettings()
		
	-- create defaults if addon is run for the first time --
	if (CombatLogger.SavedSettings.playSound == nil) then
		CombatLogger.SavedSettings.playSound = true
	end
	
	if (CombatLogger.SavedSettings.MAX_FILE_LINES == nil) then
		CombatLogger.SavedSettings.MAX_FILE_LINES = 50000
	end
	
	-- load values from file
	playSound = CombatLogger.SavedSettings.playSound
	MAX_FILE_LINES = CombatLogger.SavedSettings.MAX_FILE_LINES
	
end

function CombatLogger.getTimeStamp()
	
	-- date 
	local year = Calendar.todaysYear
	local month = Calendar.todaysMonth
	if month < 10 then month = "0"..month end
	local day = Calendar.todaysDay
	if day < 10 then day = "0"..day end
	local dDate = year .. "-" .. month .. "-" .. day
	
	-- time
	local timer, Time = 0, GetComputerTime()
	local dSec = Time % 60
	if dSec < 10 then dSec = "0"..dSec end
	Time = (Time - dSec) / 60
	local dMin = Time % 60
	if dMin < 10 then dMin = "0"..dMin end
	Time = (Time - dMin) / 60
	local dHour = Time
	if dHour < 10 then dHour = "0"..dHour end
	--local tTime = dHour..":"..dMin..":"..dSec
	local tTime = dHour .."".. dMin .."".. dSec
	
	return dDate .. "-" .. tTime
end

function CombatLogger.rname(name)
	return tostring(string.match(tostring(name), '[A-Za-z]*'))
end

function CombatLogger.toboolean(sString)
	return not not sString
end

function Echo(sString)
	EA_ChatWindow.Print(towstring(sString))
end