local Enemy = Enemy

function Enemy.CommunicationInitialize ()
	
	Enemy.chatAdditionalDelay = 0
	Enemy.chatLastTimeSend = -1
	Enemy.chatFilters = {}
	
	RegisterEventHandler (SystemData.Events.CHAT_TEXT_ARRIVED, "Enemy.OnChatTextArrived")	
	Enemy.TriggerEvent ("CommunicationInitialized")
end

function Enemy.CanSendChatMessage ()
	return (Enemy.time >= Enemy.chatLastTimeSend + Enemy.Settings.chatDelay + Enemy.chatAdditionalDelay)
end

function Enemy.SendChatMessage (text)
	
	--SystemData.UserInput.ChatText = text;
	--BroadcastEvent (SystemData.Events.SEND_CHAT_TEXT);
	SendChatText (text, L"")
	
	--d(L"SendChatMessage: "..Enemy.toWString (text))
	
	Enemy.chatLastTimeSend = Enemy.time
	Enemy.chatAdditionalDelay = 0
end

function Enemy.ThrottleChat ()
	Enemy.chatAdditionalDelay = Enemy.chatAdditionalDelay + Enemy.Settings.chatThrottleDelay
end

function Enemy.UnthrottleChat ()
	
	Enemy.chatAdditionalDelay = Enemy.chatAdditionalDelay - Enemy.Settings.chatThrottleDelay
	
	if (Enemy.chatAdditionalDelay < 0)
	then
		Enemy.chatAdditionalDelay = 0
	end
end

function Enemy.OnChatTextArrived ()
	
	local chat_type = GameData.ChatData.type
	local chat_filters = SystemData.ChatLogFilters

	local text = Enemy.toWString (GameData.ChatData.text)
	if (text == nil or text == L"") then return end
	
	if (chat_type == chat_filters.USER_ERROR)
	then
		if (text:find (L"Slow down!"))
		then
			Enemy.ThrottleChat ()
		end
	elseif (Enemy.chatFilters[chat_type] == true)
	then
		Enemy.UnthrottleChat ()
		Enemy.TriggerEvent ("ChatTextArrived", chat_type, Enemy.FixString (GameData.ChatData.name), text)
	end
end

--------------------------------------------------------------- Helpers
function Enemy.FindCustomChannel (name)

	-- local name = L": "..Enemy.toWString (name:lower ())..L"]"
	
	for k, v in pairs (ChatSettings.Channels)
	do
		if (v.labelText ~= nil)
		then
			local str = Enemy.toWString (v.labelText:lower ())
			local chan = Enemy.toWString (name:lower ())
			
			local chanFrench
								
			if(name == L"party")
			then
				chanFrench = Enemy.toWString(L"groupe")
			elseif (name == L"warband")
			then
				chanFrench = Enemy.toWString(L"bande")
			end			
			-- SendChatText (L"/p FindCustomChannel "..str, L"")	

			if (str:find (name) or str:find (chanFrench))		
			then
				return v.serverCmd, k
			end
		end
	end

    return false, false
end

function Enemy.HideChannel (channelId)
	for _,wndGroup in ipairs (EA_ChatWindowGroups)
	do
		if (wndGroup.used == true)
		then
			for tabId, tab in ipairs (wndGroup.Tabs)
			do
				local tabName = EA_ChatTabManager.GetTabName (tab.tabManagerId)
		
				if (tabName) then
					if (tab.tabText ~= L"Enemy")
					then
						LogDisplaySetFilterState (tabName.."TextLog", "Chat", channelId, false)
					else
						LogDisplaySetFilterState (tabName.."TextLog", "Chat", channelId, true)
						LogDisplaySetFilterColor (tabName.."TextLog", "Chat", channelId, 150, 250, 100)
					end
				end
			end
		end
	end	
end

function Enemy.JoinChannel (name, callback)

	--d (L"Enemy.JoinChannel: "..Enemy.toWString (name))

	-- send command to join the channel
	Enemy.AddTaskAction ("channel",
		function ()
		
			local channel, channelId = Enemy.FindCustomChannel (name)
			if (not channel)
			then
				if (not Enemy.CanSendChatMessage ()) 
				then 
					return false 
				end
				Enemy.SendChatMessage (L"/channeljoin "..name);
			end
			
			return true
		end
	)
		
	-- waiting for join the channel
	Enemy.AddTaskAction ("channel",
		function ()
		
			local channel, channelId = Enemy.FindCustomChannel (name)
			if (channel)
			then
				-- SendChatText (L"/p Enemy.JoinChannel "..name, L"")				
				callback (name, channel, channelId)
				return true
			end
			
			-- SendChatText (L"/p Enemy.JoinChannel NOK"..name, L"")
			return false
		end
	)
end

function Enemy.LeaveChannel (name, callback)

	-- send command to leave the channel
	Enemy.AddTaskAction ("channel",
		function (data)
		
			if (not Enemy.CanSendChatMessage ()) then return false end
			
			Enemy.SendChatMessage (L"/channelleave "..name)
			callback ()
			
			return true
		end
	)
end